import { useContext } from "react";
import { Link } from "react-router-dom";
import { AppContext } from "../../App";

const Footer = () => {
  const { tabIndex, setTabIndex } = useContext(AppContext);

  return (
    <div className="fixed bottom-0 left-0 right-0  h-14 pt-2 text-center   border-t phone-width  ">
      <div className="flex">
        <div className="w-1/4 grid place-items-center">
          <Link
            to="/"
            onClick={() => {
              setTabIndex(1);
            }}
          >
            <div className="h-6  relative rounded-md ">
              <img src="/icon/map-two.svg" />
              {tabIndex == 1 && (
                <div className=" absolute top-0  left-0  w-full h-full  bg-orange-500 opacity-50 rounded-lg" />
              )}
            </div>
            <div
              className={`h-12 text-bottom text-xs ${
                tabIndex == 1 ? " text-orange-500" : ""
              }`}
            >
              地块
            </div>
          </Link>
        </div>

        <div className="w-1/4 grid place-items-center ">
          <Link
            to="/notify"
            onClick={() => {
              setTabIndex(2);
            }}
          >
            <div className="h-6  relative rounded-md  ">
              <img src="/icon/toolkit.svg"  className="mx-auto"/>
              {tabIndex == 2 && (
                <div className=" absolute top-0  left-0  w-full h-full  bg-orange-500 opacity-50 rounded-lg" />
              )}
            </div>
            <div
              className={`h-12 text-bottom text-xs   ${
                tabIndex == 2 ? " text-orange-500" : ""
              }`}
            >
              工具箱
            </div>
          </Link>
        </div>
        <div className="w-1/4 grid place-items-center">
          <Link
            to="/sale"
            onClick={() => {
              setTabIndex(3);
            }}
          >
            <div className="h-6  relative rounded-md">
              <img src="/icon/layers.svg" />
              {tabIndex == 3 && (
                <div className=" absolute top-0  left-0  w-full h-full  bg-orange-500 opacity-50 rounded-lg" />
              )}
            </div>
            <div
              className={`h-12 text-bottom text-xs ${
                tabIndex == 3 ? " text-orange-500" : ""
              }`}
            >
             图层 
            </div>
          </Link>
        </div>
        <div className="w-1/4 grid place-items-center">
          <Link
            to="/user"
            onClick={() => {
              setTabIndex(4);
            }}
          >
            <div className="h-6  relative rounded-md">
              <img src="/icon/user.svg" />
              {tabIndex == 4 && (
                <div className=" absolute top-0  left-0  w-full h-full  bg-orange-500 opacity-50 rounded-lg" />
              )}
            </div>
            <div
              className={`h-12 text-bottom text-xs ${
                tabIndex == 4 ? " text-orange-500" : ""
              }`}
            >
              我的
            </div>
          </Link>
        </div>
      </div>
    </div>
  );
};
export default Footer;
