import { createContext, useEffect, useState } from "react";
import "./App.css";
import { BrowserRouter, Route, Routes } from "react-router-dom";
import Login from "./components/login/Login";
import Register from "./components/login/Register";
import Land from "./components/land/Land";
import Layers from "./components/layers/Layers";
import Toolkit from "./components/toolkit/Toolkit";
import User from "./components/user/User";
type AppContextType = {
  theme: string;
  tabIndex: number;
  setTabIndex: any;
  searchHis: string[];
  setSearchHis: any;
};

const AppContext = createContext<AppContextType>({
  theme: "light",
  tabIndex: 0,
  setTabIndex: null,
  searchHis: [],
  setSearchHis: null,
});
function App() {
  const [theme, setTheme] = useState<string>("light");
  const [searchHis, setSearchHis] = useState([]);
  const [tabIndex, setTabIndex] = useState<number>(1);
  useEffect(() => {
    const mediaQuery = window.matchMedia("(prefers-color-scheme: dark)");
    const theme = mediaQuery.matches ? "dark" : "light";
    setTheme(theme);

    const handleChange = () => {
      setTheme(mediaQuery.matches ? "dark" : "light");
    };

    mediaQuery.addListener(handleChange);

    return () => {
      mediaQuery.removeListener(handleChange);
    };
  }, []);
  return (
    <AppContext.Provider
      value={{
        theme,
        tabIndex,
        setTabIndex,
        searchHis,
        setSearchHis,
      }}
    >
      <BrowserRouter>
        <Routes>
          <Route path="/" element={<Land />}></Route>
          <Route path="/toolkit" element={<Toolkit />}></Route>
          <Route path="/layers" element={<Layers />}></Route>
          <Route path="/user" element={<User />}></Route>
          <Route path="/login" element={<Login />} />
          <Route path="/register" element={<Register />} />
        </Routes>
      </BrowserRouter>
    </AppContext.Provider>
  );
}
export { AppContext };
export default App;
