import { useEffect, useRef } from "react";
import Footer from "../common/Footer";
import Map from 'ol/Map';
import View from 'ol/View';
import TileLayer from 'ol/layer/Tile';
import OSM from 'ol/source/OSM';
import 'ol/ol.css';
import './Land.css'
import XYZ from "ol/source/XYZ";

const Land = ()=>{
    const mapRef = useRef(null);
    const gaodeSource = new XYZ({
      url: 'https://webrd02.is.autonavi.com/appmaptile?lang=zh_cn&size=1&scale=1&style=8&x={x}&y={y}&z={z}',
    });
 
    const gaodeLayer = new TileLayer({
      source: gaodeSource,
    });
    useEffect(() => {
      if (mapRef.current) {
        const map = new Map({
          target: mapRef.current,
          layers: [
            gaodeLayer
          ],
          view: new View({
            center: [0, 0],
            zoom: 3,
          }),
        });
  
        return () => {
          map.setTarget();
        };
      }
    }, []);
  
    return(<>
    <div ref={mapRef}  className=" bottom-14 h-3/5  w-full  absolute"></div>
    <Footer></Footer>
    </>)
}

export default Land;