import Footer from "../common/Footer";
import { useEffect, useRef } from "react";
import Map from "ol/Map";
import View from "ol/View";
import TileLayer from "ol/layer/Tile";
import "ol/ol.css";
import XYZ from "ol/source/XYZ";
const Layers = () => {
  const mapRef = useRef(null);
  const gaodeSource = new XYZ({
    url: "https://webrd02.is.autonavi.com/appmaptile?lang=zh_cn&size=1&scale=1&style=8&x={x}&y={y}&z={z}",
  });

  const gaodeLayer = new TileLayer({
    source: gaodeSource,
  });
  useEffect(() => {
    if (mapRef.current) {
      const map = new Map({
        target: mapRef.current,
        layers: [gaodeLayer],
        view: new View({
          center: [0, 0],
          zoom: 3,
          minZoom: 3, // 设置最小缩放等级为 5
          maxZoom: 18, // 设置最大缩放等级为 15
        }),
      });

      return () => {
        map.setTarget();
      };
    }
  }, []);

  return (
    <>
      <div ref={mapRef} className=" bottom-14  top-0 w-full  absolute"></div>
      <Footer></Footer>
    </>
  );
};

export default Layers;
