import { memo, SVGProps, useContext } from "react";
import { AppContext } from "../../App";

export const MINUS = memo((props: SVGProps<SVGSVGElement>) => {
  const { theme } = useContext(AppContext);
  const theme_color = theme === "dark" ? "white" : "black";
  const color = props.color !== undefined ? props.color : theme_color;
  return (
    <svg
      width="24"
      height="24"
      viewBox="0 0 24 24"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      {...props}
    >
      <path d="M3 12L21 12" stroke={color} />
    </svg>
  );
});

export const Plus = memo((props: SVGProps<SVGSVGElement>) => {
  const { theme } = useContext(AppContext);
  const theme_color = theme === "dark" ? "white" : "black";
  const color = props.color !== undefined ? props.color : theme_color;
  return (
    <svg
      width="24"
      height="24"
      viewBox="0 0 24 24"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      {...props}
    >
      <path d="M12 3V21" stroke={color} />
      <path d="M3 12L21 12" stroke={color} />
    </svg>
  );
});

export const ForwardArrow = memo((props: SVGProps<SVGSVGElement>) => {
  const { theme } = useContext(AppContext);
  const theme_color = theme === "dark" ? "white" : "black";
  const color = props.color !== undefined ? props.color : theme_color;
  return (
    <svg
      width="24"
      height="24"
      viewBox="0 0 24 24"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      {...props}
    >
      <path d="M14.2827 5L20.9998 12L14.2827 19" stroke={color} />
      <line
        x1="20.6279"
        y1="12.1089"
        x2="2.89487"
        y2="12.1089"
        stroke={color}
      />
    </svg>
  );
});

export const Backward = memo((props: SVGProps<SVGSVGElement>) => {
  const { theme } = useContext(AppContext);
  const theme_color = theme === "dark" ? "white" : "black";
  const color = props.color !== undefined ? props.color : theme_color;
  return (
    <svg
      width="24"
      height="24"
      viewBox="0 0 24 24"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      {...props}
    >
      <path d="M9.61182 19L2.89474 12L9.61182 5" stroke={color} />
      <line x1="3.2666" y1="11.8911" x2="20.9997" y2="11.8911" stroke={color} />
    </svg>
  );
});

export const Heart = memo((props: SVGProps<SVGSVGElement>) => {
  const { theme } = useContext(AppContext);
  const theme_color = theme === "dark" ? "white" : "black";
  const color = props.color !== undefined ? props.color : theme_color;
  const file_color = props.fill !== undefined ? props.fill : "none";
  return (
    <svg
      width="24"
      height="24"
      viewBox="0 0 24 24"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      {...props}
    >
      <path
        d="M2.77216 3.77216C0.40928 6.13503 0.409282 9.96602 2.77216 12.3289L11.937 21.4937L12 21.4307L12.0631 21.4938L21.2279 12.329C23.5908 9.96609 23.5908 6.13511 21.2279 3.77223C18.865 1.40936 15.034 1.40936 12.6712 3.77224L12.3536 4.08978C12.1584 4.28505 11.8418 4.28505 11.6465 4.08978L11.3289 3.77216C8.96601 1.40928 5.13503 1.40928 2.77216 3.77216Z"
        stroke={color}
        fill={file_color}
      />
    </svg>
  );
});

export const SearchIcon = memo((props: SVGProps<SVGSVGElement>) => {
  const { theme } = useContext(AppContext);
  const theme_color = theme === "dark" ? "white" : "black";
  const color = props.color !== undefined ? props.color : theme_color;
  return (
    <svg
      width="24"
      height="24"
      viewBox="0 0 24 24"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      {...props}
    >
      <path
        d="M11 20C15.9706 20 20 15.9706 20 11C20 6.02944 15.9706 2 11 2C6.02944 2 2 6.02944 2 11C2 15.9706 6.02944 20 11 20Z"
        stroke={color}
      />
      <path d="M22 21.9999L18.7823 18.7822" stroke={color} />
    </svg>
  );
});

export const MenuIcon = memo((props: SVGProps<SVGSVGElement>) => {
  const { theme } = useContext(AppContext);
  const theme_color = theme === "dark" ? "white" : "black";
  const color = props.color !== undefined ? props.color : theme_color;
  return (
    <svg
      width="24"
      height="24"
      viewBox="0 0 24 24"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      {...props}
    >
      <path d="M0.306763 12H15.9824" stroke={color} />
      <path d="M0.306641 5H23.6931" stroke={color} />
      <path d="M0.306641 19H23.6931" stroke={color} />
    </svg>
  );
});

export const Close = memo((props: SVGProps<SVGSVGElement>) => {
  const { theme } = useContext(AppContext);
  const theme_color = theme === "dark" ? "white" : "black";
  const color = props.color !== undefined ? props.color : theme_color;
  return (
    <svg
      width="24"
      height="24"
      viewBox="0 0 24 24"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      {...props}
    >
      <path d="M6 6L18.7742 18.7742" stroke={color} strokeLinejoin="round" />
      <path
        d="M6 18.7744L18.7742 6.00022"
        stroke={color}
        strokeLinejoin="round"
      />
    </svg>
  );
});



export const Refresh = memo((props: SVGProps<SVGSVGElement>) => {
  const { theme } = useContext(AppContext);
  const theme_color = theme === "dark" ? "white" : "black";
  const color = props.color !== undefined ? props.color : theme_color;
  return (
    <svg
      width="25"
      height="24"
      viewBox="0 0 25 24"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      {...props}
    >
      <path
        d="M3.7562 9.38144C4.30918 7.45296 5.45849 5.74904 7.0394 4.5139C8.62031 3.27876 10.5517 2.5758 12.5566 2.50579C14.5616 2.43577 16.5373 3.00229 18.2005 4.12414C19.8637 5.246 21.1291 6.8656 21.8153 8.75081"
        stroke={color}
        strokeLinejoin="round"
      />
      <path
        d="M21.6409 15.6931C20.9263 17.3868 19.7356 18.8368 18.2132 19.8673C16.6908 20.8977 14.9022 21.4643 13.0642 21.4984C11.2262 21.5324 9.41779 21.0325 7.85828 20.0592C6.29878 19.0858 5.05517 17.681 4.27826 16.0149"
        stroke={color}
        strokeLinejoin="round"
      />
      <path
        d="M8.60114 15.0242L4.14699 15.3157L2.49292 19.5527"
        stroke={color}
      />
      <path
        d="M17.0747 9.36035L21.7004 9.34898L23.2797 5.13764"
        stroke={color}
      />
    </svg>
  );
});


export const Location = memo((props: SVGProps<SVGSVGElement>) => {
  const { theme } = useContext(AppContext);
  const theme_color = theme === "dark" ? "white" : "black";
  const color = props.color !== undefined ? props.color : theme_color;
  return (
    <svg
      width="24"
      height="25"
      viewBox="0 0 24 25"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      {...props}
    >
      <path
        d="M22 11C22 16.5228 12 24 12 24C12 24 2 16.5228 2 11C2 5.47715 6.47715 1 12 1C17.5228 1 22 5.47715 22 11Z"
        stroke={color}
      />
      <circle cx="12" cy="11" r="3" stroke={color} />
    </svg>
  );
});



export const Export = memo((props: SVGProps<SVGSVGElement>) => {
  const { theme } = useContext(AppContext);
  const theme_color = theme === "dark" ? "white" : "black";
  const color = props.color !== undefined ? props.color : theme_color;
  return (
    <svg
      width="24"
      height="24"
      viewBox="0 0 24 24"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      {...props}
    >
      <path d="M17 6L11.5 1L6 6" stroke={color} />
      <line
        y1="-0.5"
        x2="13"
        y2="-0.5"
        transform="matrix(0 1 1 0 12 1)"
        stroke={color}
      />
      <path d="M3 12V22H20V12" stroke={color} />
    </svg>
  );
});



export const Forward = memo((props: SVGProps<SVGSVGElement>) => {
  const { theme } = useContext(AppContext);
  const theme_color = theme === "dark" ? "white" : "black";
  const color = props.color !== undefined ? props.color : theme_color;
  return (
    <svg
      width="24"
      height="24"
      viewBox="0 0 24 24"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      {...props}
    >
      <path d="M9 5L15.9632 11.9632L9 18.9263" stroke={color} />
    </svg>
  );
});

export const Up = memo((props: SVGProps<SVGSVGElement>) => {
  const { theme } = useContext(AppContext);
  const theme_color = theme === "dark" ? "white" : "black";
  const color = props.color !== undefined ? props.color : theme_color;
  return (
    <svg
      width="24"
      height="24"
      viewBox="0 0 24 24"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      {...props}
    >
      <path
        d="M5.51843 15.4448L12.4816 8.48165L19.4448 15.4448"
        stroke={color}
      />
    </svg>
  );
});

export const Down = memo((props: SVGProps<SVGSVGElement>) => {
  const { theme } = useContext(AppContext);
  const theme_color = theme === "dark" ? "white" : "black";
  const color = props.color !== undefined ? props.color : theme_color;
  return (
    <svg
      width="24"
      height="24"
      viewBox="0 0 24 24"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      {...props}
    >
      <path
        d="M19.4447 8.48145L12.4815 15.4446L5.51836 8.48144"
        stroke={color}
      />
    </svg>
  );
});

export const Back = memo((props: SVGProps<SVGSVGElement>) => {
  const { theme } = useContext(AppContext);
  const theme_color = theme === "dark" ? "white" : "black";
  const color = props.color !== undefined ? props.color : theme_color;
  return (
    <svg
      width="24"
      height="24"
      viewBox="0 0 24 24"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      {...props}
    >
      <path d="M15.963 18.9263L8.99984 11.9631L15.963 4.99993" stroke={color} />
    </svg>
  );
});

export const Filter = memo((props: SVGProps<SVGSVGElement>) => {
  const { theme } = useContext(AppContext);
  const theme_color = theme === "dark" ? "white" : "black";
  const color = props.color !== undefined ? props.color : theme_color;
  return (
    <svg
      width="24"
      height="24"
      viewBox="0 0 24 24"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      {...props}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M3 7.5V8.5H21V7.5H3ZM10 16.5H14V15.5H10V16.5ZM18 12.5H6V11.5H18V12.5Z"
        fill={color}
      />
    </svg>
  );
});

export const GridView = memo((props: SVGProps<SVGSVGElement>) => {
  const { theme } = useContext(AppContext);
  const theme_color = theme === "dark" ? "white" : "black";
  const color = props.color !== undefined ? props.color : theme_color;
  return (
    <svg
      width="24"
      height="24"
      viewBox="0 0 24 24"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      {...props}
    >
      <rect x="4.50024" y="4.5" width="6" height="6" stroke={color} />
      <rect x="4.50024" y="13.5" width="6" height="6" stroke={color} />
      <rect x="13.5002" y="4.5" width="6" height="6" stroke={color} />
      <rect x="13.5002" y="13.5" width="6" height="6" stroke={color} />
    </svg>
  );
});

export const Gallery = memo((props: SVGProps<SVGSVGElement>) => {
  const { theme } = useContext(AppContext);
  const theme_color = theme === "dark" ? "white" : "black";
  const color = props.color !== undefined ? props.color : theme_color;
  return (
    <svg
      width="24"
      height="24"
      viewBox="0 0 24 24"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      {...props}
    >
      <path d="M3.04492 18.0259H20.9553" stroke={color} />
      <path d="M20.8018 17.5327L20.8018 21.3921" stroke={color} />
      <path d="M3.30518 17.5327L3.30518 21.3921" stroke={color} />
      <rect x="3.25" y="3.45508" width="17.5" height="10.7458" stroke={color} />
    </svg>
  );
});

export const ListView = memo((props: SVGProps<SVGSVGElement>) => {
  const { theme } = useContext(AppContext);
  const theme_color = theme === "dark" ? "white" : "black";
  const color = props.color !== undefined ? props.color : theme_color;
  return (
    <svg
      width="24"
      height="24"
      viewBox="0 0 24 24"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      {...props}
    >
      <path d="M12.2051 17H19.9768" stroke={color} />
      <path d="M12.2283 7H20" stroke={color} />
      <rect x="2.51318" y="3.45508" width="7" height="7" stroke={color} />
      <rect x="2.51318" y="13.5142" width="7" height="7" stroke={color} />
    </svg>
  );
});
