# XPlot - 数字地块管理系统

XPlot是一个基于Tauri, React和TypeScript开发的数字地块管理桌面应用程序，用于显示和管理土地地块信息。

## 应用类型

XPlot是一个混合型应用：
- **桌面应用**：使用Tauri框架将Web技术打包成原生桌面应用，可在Windows、macOS和Linux上运行
- **Web特性**：前端使用React构建，可以独立运行为Web应用
- **跨平台**：单一代码库支持多平台部署

Tauri框架使用Rust创建本地窗口，在其中嵌入WebView来渲染React前端，同时提供JavaScript与Rust后端通信的能力，使应用可以访问系统功能。

## 什么是Tauri？

Tauri是一个用于构建跨平台桌面应用的现代框架，具有以下特点：

- **轻量级**：比Electron等同类框架生成的应用体积小很多（通常小10-100倍）
- **高性能**：使用Rust编写的后端，资源占用低，运行速度快
- **安全性**：采用细粒度的权限系统，应用只能访问明确允许的系统资源
- **跨平台**：支持Windows、macOS和Linux系统
- **前端不受限**：可以使用任何Web技术（如React、Vue、Angular等）构建UI
- **系统集成**：通过Rust插件系统，可以访问系统API和原生功能

Tauri的工作原理是在前端（Web技术）和操作系统之间建立桥梁：
- 使用原生Webview渲染前端界面
- 提供Rust API让JavaScript能够与系统交互
- 使用系统原生对话框和菜单
- 支持原生系统通知

与Electron相比，Tauri使用系统自带的WebView引擎而不是捆绑完整的Chromium，这使应用体积更小，资源消耗更低。

## 版本支持

### 当前版本

XPlot项目使用的技术版本：
- **Tauri**: 2.0.0（正式版）
- **React**: 18.2.0
- **OpenLayers**: 10.1.0
- **TypeScript**: 5.2.2
- **Vite**: 5.3.1
- **TailwindCSS**: 3.4.10

### 平台支持

当前项目配置主要针对桌面平台：
- **Windows**: 支持
- **macOS**: 支持（项目中有针对Apple Silicon的配置）
- **Linux**: 支持

### 移动端支持潜力

虽然项目代码中有`#[cfg_attr(mobile, tauri::mobile_entry_point)]`标记，表明对移动端有基础支持，但项目当前并未完全配置移动端环境：

- 没有找到`capacities`目录下的移动端配置文件（应有`android.json`和`ios.json`）
- 没有发现移动端特定的插件配置
- 缺少移动端界面适配代码

要扩展到移动端需要额外的工作：
1. 创建移动端特定项目配置
2. 适配UI以支持不同屏幕尺寸
3. 处理移动端特有的用户交互和权限
4. 添加相应的构建脚本和配置

## 功能特点

- 交互式地块地图显示（基于OpenLayers）
- 高德地图作为底图
- 地块信息管理
- 多图层显示
- 工具箱功能
- 用户账户管理
- 支持深色/浅色主题切换

## 技术栈

- 前端: React 18 + TypeScript + Vite
- 地图库: OpenLayers
- UI框架: TailwindCSS
- 桌面应用打包: Tauri (Rust)
- 路由: React Router DOM

## 外部依赖服务

XPlot依赖以下外部服务：

1. **后端API服务**：
   - 开发环境：`http://localhost:8642`
   - 生产环境：`http://120.26.166.245:8642`
   - 提供用户认证、地块数据管理等功能

2. **高德地图服务**：
   - 高德卫星图层
   - 高德道路图层
   - 用于显示地理信息和地块位置

## 安装和运行

### 前提条件

- **Node.js**: 18.0.0+ 或 20.0.0+（Vite 5.x 的要求）
- **Yarn包管理器**: 1.22.0+
- **Rust环境**: 1.66.0+（Tauri 2.0的要求）

### macOS安装Rust环境

```bash
curl --proto '=https' --tlsv1.2 -sSf https://sh.rustup.rs | sh
source "$HOME/.cargo/env"
```

### 项目安装

1. 克隆项目
```bash
git clone [项目仓库URL]
cd xplot
```

2. 安装依赖
```bash
yarn install
```

3. 开发模式运行
```bash
yarn tauri dev
```

4. 仅运行前端 (不包括Tauri)
```bash
yarn dev
```

5. 构建应用
```bash
yarn tauri build
```

### 桌面应用打包与部署

1. 开发模式下运行桌面应用：
```bash
yarn tauri dev
```

2. 构建桌面应用安装包：
```bash
yarn tauri build
```
   这将在`src-tauri/target/release`目录中生成可执行文件和安装包：
   - **macOS**：生成`.app`和`.dmg`文件
   - **Windows**：生成`.exe`和`.msi`文件
   - **Linux**：生成`.AppImage`、`.deb`或`.rpm`文件（取决于配置）

3. 自定义桌面应用构建：
   编辑`src-tauri/tauri.conf.json`配置文件，可以修改应用名称、窗口大小、图标等。

### Web应用打包与部署

1. 仅构建Web前端部分：
```bash
yarn build
```
   这将在`dist`目录下生成静态网站文件。

2. 预览构建后的静态网站：
```bash
yarn preview
```

3. 部署到Web服务器：
   将`dist`目录中的所有文件上传到Web服务器，确保:
   - 配置正确的API地址（修改`.env.production`文件中的`VITE_API_URL`）
   - 配置服务器以将所有路由重定向到`index.html`（支持SPA路由）

4. 部署示例（Nginx配置）：
```nginx
server {
    listen 80;
    server_name your-domain.com;
    root /path/to/dist;
    
    location / {
        try_files $uri $uri/ /index.html;
    }
}
```

### 两种模式的区别

- **桌面应用模式**：包含完整Tauri功能，可访问系统API，作为独立应用运行
- **Web应用模式**：仅包含前端部分，无法使用Tauri提供的系统功能，需部署到Web服务器

## 项目结构

- `/src` - 前端React代码
- `/src-tauri` - Tauri/Rust后端代码
- `/public` - 静态资源

## 推荐的IDE设置

- [VS Code](https://code.visualstudio.com/) + [Tauri](https://marketplace.visualstudio.com/items?itemName=tauri-apps.tauri-vscode) + [rust-analyzer](https://marketplace.visualstudio.com/items?itemName=rust-lang.rust-analyzer)

## 贡献指南

[待添加]

## 许可证

[待添加]

## 联系方式

[待添加]
