import Footer from "../common/Footer";
import { useEffect, useRef } from "react";
import Map from "ol/Map";
import View from "ol/View";
import TileLayer from "ol/layer/Tile";
import "ol/ol.css";
import XYZ from "ol/source/XYZ";
const Layers = () => {
  const mapRef = useRef(null);
  const gaodeSource = new XYZ({
    url: "https://webst01.is.autonavi.com/appmaptile?style=6&x={x}&y={y}&z={z}",
  });

  const gaodeLayer = new TileLayer({
    source: gaodeSource,
  });
  useEffect(() => {
    if (mapRef.current) {
      const map = new Map({
        target: mapRef.current,
        layers: [
            new TileLayer({
              source: new XYZ({
                url: 'https://webst02.is.autonavi.com/appmaptile?style=6&x={x}&y={y}&z={z}',
              }),
            }), // 高德卫星图层
            new TileLayer({
              source: new XYZ({
                url: 'https://wprd0{1-4}.is.autonavi.com/appmaptile?x={x}&y={y}&z={z}&lang=zh_cn&size=1&scl=1&style=8',
              }),
            }), // 高德道路图层
          ],
          view: new View({
            center: [120, 30],
            zoom: 3,
            maxZoom:18,
            minZoom:3
          }),
      });
      
      return () => {
        map.setTarget();
      };
    }
  }, []);

  return (
    <>
      <div ref={mapRef} className=" bottom-14  top-0 w-full  absolute"></div>
      <Footer></Footer>
    </>
  );
};

export default Layers;
