package model

import (
	"time"

	geojson "github.com/paulmach/go.geojson"
)

type GeoData geojson.Feature

// FlyDefenseRoute 飞防路线
type OptRoute struct {
	ID         string                 `json:"id"`   // 路线ID
	Name       string                 `json:"name"` // 路线名称
	Type       string                 `json:"type"`
	Properties map[string]interface{} `json:"properties"`
	OptTime    time.Time              `json:"opt_time"`
	RouteLine  geojson.Feature        `json:"route_line"` // 路线坐标点 (PostGIS LineString)
}

// OptArea 作业区域
type OptArea struct {
	ID            string                 `json:"id"`   // 区域ID
	Name          string                 `json:"name"` // 区域名称
	Type          string                 `json:"type"`
	Properties    map[string]interface{} `json:"properties"`
	OptTime       time.Time              `json:"opt_time"`
	Area          geojson.Feature        `json:"area"` // 区域边界坐标点
	RelatedAdmDds []string
}
