package handler

import (
	"context"
	"fmt"

	"github.com/cloudwego/hertz/pkg/app"
	"github.com/twpayne/go-geom"
	"github.com/twpayne/go-geom/encoding/geojson"
	"github.com/twpayne/go-geom/encoding/wkt"
)

func SaveGeometry(ctx context.Context, c *app.RequestContext) {

}

func UpdateGeometry(ctx context.Context, c *app.RequestContext) {

}

func GetGeometry(ctx context.Context, c *app.RequestContext) {
	var id string
	c.BindAndValidate(&id)
}

func DeleteGeometry(ctx context.Context, c *app.RequestContext) {
	var id string
	c.BindAndValidate(&id)
}

func FindRelatedGeometry(ctx context.Context, c *app.RequestContext) {

}

func CheckTwoOptAreaIsCross(ctx context.Context, c *app.RequestContext) {

}

func TransGeoToWKT(geojsonStr string) (string, error) {
	// 解码GeoJSON字符串为geom.T类型
	var g geom.T
	if err := geojson.Unmarshal([]byte(geojsonStr), &g); err != nil {
		return "", fmt.Errorf("error unmarshalling GeoJSON: %w", err)
	}

	// 将geom.T类型转换为WKT
	wktStr, err := wkt.Marshal(g)
	if err != nil {
		return "", fmt.Errorf("error marshalling to WKT: %w", err)
	}

	return string(wktStr), nil
}
