package data

import (
	"database/sql"
	"os"
	"path/filepath"
	"testing"

	_ "github.com/lib/pq"
)

func TestProcessJsonFile(t *testing.T) {
	// 设置测试数据库连接
	dbURL := os.Getenv("TEST_DATABASE_URL")
	if dbURL == "" {
		dbURL = "postgres://liang:postgres@localhost/xpolt?sslmode=disable"
	}

	// 连接数据库
	db, err := sql.Open("postgres", dbURL)
	if err != nil {
		t.Fatalf("数据库连接失败: %v", err)
	}
	defer db.Close()

	// 测试数据库连接
	if err := db.Ping(); err != nil {
		t.Fatalf("数据库连接测试失败: %v", err)
	}

	// 获取测试文件路径
	testFile := filepath.Join("testdata", "data.json")

	// 测试文件处理
	err = ProcessJsonFile(testFile, db)
	if err != nil {
		t.Errorf("处理JSON文件失败: %v", err)
	}
}

func TestMsdataTransToOptArea(t *testing.T) {
	// 创建测试数据
	testData := Msdata{
		ID:               1,
		MemberLandId:     4,
		BlockCrop:        "玉米",
		BlockArea:        100.0000,
		BlockCoordinates: "112.815624,37.460469",
		EnclosureCoordinates: `[[[112.814746,37.459434],[112.813547,37.460806],
			[112.814086,37.462012],[112.815706,37.461738],[112.816799,37.461269],
			[112.817074,37.460346],[112.816888,37.45944],[112.816145,37.458709]]]`,
		CreateTime: "2024-04-02 11:19:44",
		UpdateTime: "2024-04-10 18:06:51",
	}

	// 测试转换
	optArea := testData.TransToOptArea()

	// 验证转换结果
	if optArea.Type != "polygon" {
		t.Errorf("期望类型为 polygon, 得到 %s", optArea.Type)
	}

	if optArea.Properties["id"] != testData.ID {
		t.Errorf("期望 ID 为 %d, 得到 %v", testData.ID, optArea.Properties["id"])
	}

	if optArea.Geometry == nil {
		t.Error("Geometry 不应该为 nil")
	}
}

func TestParseEnclosureCoordinates(t *testing.T) {
	testData := Msdata{
		EnclosureCoordinates: `[[[112.814746,37.459434],[112.813547,37.460806],
			[112.814086,37.462012],[112.815706,37.461738]]]`,
	}

	geometry, err := testData.parseEnclosureCoordinates()
	if err != nil {
		t.Errorf("解析坐标失败: %v", err)
	}

	if geometry.Type != "Polygon" {
		t.Errorf("期望类型为 Polygon, 得到 %s", geometry.Type)
	}

}
