package model

import (
	"time"

	geojson "github.com/paulmach/go.geojson"
)

type OptRoute struct {
	ID         int                    `json:"id"` // 路线ID
	Type       string                 `json:"type"`
	Properties map[string]interface{} `json:"properties"`
	OptTime    time.Time              `json:"opt_time"`
	Geometry   *geojson.Geometry      `json:"geometry"`
}

// OptArea 作业区域
type OptArea struct {
	ID         int                    `json:"id"` // 区域ID
	Type       string                 `json:"type"`
	Properties map[string]interface{} `json:"properties"`
	OptTime    time.Time              `json:"opt_time"`
	Geometry   *geojson.Geometry      `json:"geometry"` // 区域边界坐标点
}

type GeoJson struct {
	ID         int                    `json:"id"`
	Opt        int                    `json:"opt"`
	Type       string                 `json:"type"`
	Properties map[string]interface{} `json:"properties"`
	Geometry   *geojson.Geometry      `json:"geometry"`
}

type CalcIds struct {
	IDS string `json:"ids"`
	Opt int    `json:"opt"`
}

type RelatedArea struct {
	Areas string `json:"ids"`
}

type Geometrys struct {
	Geometry *geojson.Geometry `json:"geometry"`
}
