package handler

import (
	"context"
	"strconv"
	"strings"

	"com.dliangx.xplot/appserver/geo"
	"com.dliangx.xplot/appserver/model"
	"github.com/cloudwego/hertz/pkg/app"
	"github.com/cloudwego/hertz/pkg/common/utils"
	"github.com/cloudwego/hertz/pkg/protocol/consts"
)

func SaveGeometry(ctx context.Context, c *app.RequestContext) {
	var req model.GeoJson
	err := c.BindAndValidate(&req)
	if err != nil {
		c.JSON(consts.StatusBadRequest, utils.H{"message": "geojson required"})
		return
	}
	if req.Opt == 1 || req.Opt == 2 {
		resp, err := geo.SaveRoute(req)
		if err != nil {
			c.JSON(consts.StatusOK, utils.H{"code": 10001, "message": err.Error()})
			return
		}
		c.JSON(consts.StatusOK, resp)
		return
	} else if req.Opt == 3 {
		resp, err := geo.SaveOptArea(req)
		if err != nil {
			c.JSON(consts.StatusOK, utils.H{"code": 10002, "message": err.Error()})
			return
		}
		c.JSON(consts.StatusOK, resp)
		return
	} else {
		c.JSON(consts.StatusBadRequest, utils.H{"message": "opt value is not allow"})
	}

}

func UpdateGeometry(ctx context.Context, c *app.RequestContext) {
	var req model.GeoJson
	err := c.BindAndValidate(&req)
	if err != nil {
		c.JSON(consts.StatusBadRequest, utils.H{"message": "geojson required"})
		return
	}
	if req.Opt == 1 || req.Opt == 2 {
		resp, err := geo.UpdateRoute(req)
		if err != nil {
			c.JSON(consts.StatusOK, utils.H{"code": 10003, "message": err.Error()})
			return
		}
		c.JSON(consts.StatusOK, resp)
		return
	} else if req.Opt == 3 {
		resp, err := geo.UpdateOptArea(req)
		if err != nil {
			c.JSON(consts.StatusOK, utils.H{"code": 10004, "message": err.Error()})
			return
		}
		c.JSON(consts.StatusOK, resp)
		return
	} else {
		c.JSON(consts.StatusBadRequest, utils.H{"message": "opt value is not allow"})
	}

}

func GetGeometry(ctx context.Context, c *app.RequestContext) {
	check_str := ""
	id, err := strconv.Atoi(c.Query("id"))
	if err != nil {
		check_str += "param id required;"
	}
	opt, err := strconv.Atoi(c.Query("opt"))
	if err != nil {
		check_str += "param opt required;"
	}
	if check_str != "" {
		c.JSON(consts.StatusBadRequest, utils.H{"message": check_str})
		return
	}

	if opt == 1 || opt == 2 {
		resp, err := geo.GetRoute(id, opt)
		if err != nil {
			c.JSON(consts.StatusOK, utils.H{"code": 10005, "message": err.Error()})
			return
		}
		c.JSON(consts.StatusOK, resp)
		return
	} else if opt == 3 {
		resp, err := geo.GetOptArea(id, opt)
		if err != nil {
			c.JSON(consts.StatusOK, utils.H{"code": 10006, "message": err.Error()})
			return
		}
		c.JSON(consts.StatusOK, resp)
		return
	} else {
		c.JSON(consts.StatusBadRequest, utils.H{"message": "opt value is not allow"})
	}
}

func DeleteGeometry(ctx context.Context, c *app.RequestContext) {
	check_str := ""
	id, err := strconv.Atoi(c.Query("id"))
	if err != nil {
		check_str += "param id required;"
	}
	opt, err := strconv.Atoi(c.Query("opt"))
	if err != nil {
		check_str += "param opt required;"
	}
	if check_str != "" {
		c.JSON(consts.StatusBadRequest, utils.H{"message": check_str})
		return
	}

	if opt == 1 || opt == 2 {
		resp, err := geo.DeleteRoute(id, opt)
		if err != nil {
			c.JSON(consts.StatusOK, utils.H{"code": 10007, "message": err.Error()})
			return
		}
		c.JSON(consts.StatusOK, resp)
		return
	} else if opt == 3 {
		resp, err := geo.DeleteOptArea(id, opt)
		if err != nil {
			c.JSON(consts.StatusOK, utils.H{"code": 10008, "message": err.Error()})
			return
		}
		c.JSON(consts.StatusOK, resp)
		return
	} else {
		c.JSON(consts.StatusBadRequest, utils.H{"message": "opt value is not allow"})
	}
}

func FindRelatedGeometry(ctx context.Context, c *app.RequestContext) {
	var req model.GeoJson
	err := c.BindAndValidate(&req)
	if err != nil {
		c.JSON(consts.StatusBadRequest, utils.H{"message": "geojson required"})
		return
	}
	if req.Opt == 1 || req.Opt == 2 {
		resp, err := geo.GetRelatedRoute(req)
		if err != nil {
			c.JSON(consts.StatusOK, utils.H{"code": 10009, "message": err.Error()})
			return
		}
		c.JSON(consts.StatusOK, resp)
		return
	} else if req.Opt == 3 {
		resp, err := geo.GetRelatedOptArea(req)
		if err != nil {
			c.JSON(consts.StatusOK, utils.H{"code": 10010, "message": err.Error()})
			return
		}
		c.JSON(consts.StatusOK, resp)
		return
	} else if req.Opt == 4 {
		resp, err := geo.GetRelatedAdmArea(req)
		if err != nil {
			c.JSON(consts.StatusOK, utils.H{"code": 10010, "message": err.Error()})
			return
		}
		c.JSON(consts.StatusOK, resp)
		return
	} else {
		c.JSON(consts.StatusBadRequest, utils.H{"message": "opt value is not allow"})
	}

}

func CalcAreasCenter(ctx context.Context, c *app.RequestContext) {
	// 获取 ids 参数
	idsStr := c.Query("ids")
	if idsStr == "" {
		c.JSON(consts.StatusBadRequest, utils.H{"message": "ids parameter required"})
		return
	}

	// 分割 ids 字符串为数组
	ids := strings.Split(idsStr, ",")
	if len(ids) == 0 {
		c.JSON(consts.StatusBadRequest, utils.H{"message": "invalid ids format"})
		return
	}

	// 调用 geo.CalcAreasCenter 计算中心点
	lat, lon, err := geo.CalcAreasCenter(ids)
	if err != nil {
		c.JSON(consts.StatusOK, utils.H{"code": 10012, "message": err.Error()})
		return
	}

	// 返回结果
	c.JSON(consts.StatusOK, utils.H{
		"latitude":  lat,
		"longitude": lon,
	})
}

func CheckTwoOptAreaIsCross(ctx context.Context, c *app.RequestContext) {
	var req []model.GeoJson
	err := c.BindAndValidate(&req)
	if err != nil {
		c.JSON(consts.StatusBadRequest, utils.H{"message": "geojson required"})
		return
	}
	if len(req) != 2 {
		c.JSON(consts.StatusBadRequest, utils.H{"message": "need tow geojson body"})
		return
	}
	res, err := geo.CheckAreasCross(req[0], req[1])
	if err != nil {
		c.JSON(consts.StatusOK, utils.H{"code": 10011, "message": err.Error()})
		return
	}
	c.JSON(consts.StatusOK, res)

}
