package main

import (
	"context"

	"github.com/cloudwego/hertz/pkg/app"
	"github.com/cloudwego/hertz/pkg/app/server"
	"github.com/cloudwego/hertz/pkg/common/utils"
	"github.com/cloudwego/hertz/pkg/protocol/consts"

	"com.dliangx.xplot/appserver/geo"
	"com.dliangx.xplot/appserver/route"
)

func main() {
	//filename := "/Users/liang/Downloads/山西省村界.geojson"
	// geo.ProcessGeoJSONFile(filename)
	h := server.Default(
		server.WithHostPorts(":8686"),
	)

	h.GET("/ping", func(ctx context.Context, c *app.RequestContext) {
		c.JSON(consts.StatusOK, utils.H{"message": "pong"})
	})

	h.POST("/geojson/process", geo.HandleProcessGeoJSON)
	route.Register(h)

	h.Spin()
}
