package util

import (
	"fmt"

	"github.com/twpayne/go-geom"
	"github.com/twpayne/go-geom/encoding/geojson"
	"github.com/twpayne/go-geom/encoding/wkt"
)

func TransGeoToWKT(geojsonStr string) (string, error) {
	// 解码GeoJSON字符串为geom.T类型
	var g geom.T
	if err := geojson.Unmarshal([]byte(geojsonStr), &g); err != nil {
		return "", fmt.Errorf("error unmarshalling GeoJSON: %w", err)
	}

	// 将geom.T类型转换为WKT
	wktStr, err := wkt.Marshal(g)
	if err != nil {
		return "", fmt.Errorf("error marshalling to WKT: %w", err)
	}

	return string(wktStr), nil
}
