CREATE EXTENSION postgis;
SELECT postgis_full_version();

DROP TABLE IF EXISTS "user";
CREATE TABLE "user" (
  "id" int4 NOT NULL GENERATED BY DEFAULT AS IDENTITY,
  "user_name" varchar(30)  NOT NULL,
  "phone_num" varchar(20)  NOT NULL,
  "salt" varchar(20) NOT NULL,
  "password" varchar(32)  NOT NULL,
  "invite_type" varchar(16)  NOT NULL,
  "created_at" timestamp,
  "updated_at" timestamp,
  "deleted_at" timestamp NULL DEFAULT NULL ,
  PRIMARY KEY ("id")
);

DROP TABLE IF EXISTS "account";
CREATE TABLE "account" (
  "id" int4 NOT NULL GENERATED BY DEFAULT AS IDENTITY,
  "user_id" varchar(20)  NOT NULL,
  "open_code" varchar(255) NOT NULL,
  "category" varchar(3),
  "created_at" timestamp,
  "updated_at" timestamp,
  "deleted_at" timestamp NULL DEFAULT NULL ,
  PRIMARY KEY ("id")
);

DROP TABLE IF EXISTS "permission";
CREATE TABLE "permission" (
  "id" int4 NOT NULL GENERATED BY DEFAULT AS IDENTITY,
  "parent_id" int4 ,
  "category" varchar(3),
  "name" varchar(30),
  "value" varchar(255),
  "status" bool,
  "sort" int4,
  "created_at" timestamp,
  "updated_at" timestamp,
  "deleted_at" timestamp NULL DEFAULT NULL ,
  PRIMARY KEY ("id")
);

DROP TABLE IF EXISTS "role";
CREATE TABLE "role" (
  "id" int4 NOT NULL GENERATED BY DEFAULT AS IDENTITY,
  "parent_id" int4 ,
  "name" varchar(30),
  "description" varchar(255),
  "category" varchar(255),
  "create_time" date,
  "created_at" timestamp,
  "updated_at" timestamp,
  "deleted_at" timestamp NULL DEFAULT NULL ,
  PRIMARY KEY ("id")
);

DROP TABLE IF EXISTS "role_permission";
CREATE TABLE "role_permission" (
  "id" int4 NOT NULL GENERATED BY DEFAULT AS IDENTITY,
  "role_id" int4,
  "permission_id" int4,
  "created_at" timestamp,
  "updated_at" timestamp,
  "deleted_at" timestamp NULL DEFAULT NULL ,
  PRIMARY KEY ("id")
);

DROP TABLE IF EXISTS "user_role";
CREATE TABLE "user_role" (
  "id" int4 NOT NULL GENERATED BY DEFAULT AS IDENTITY,
  "role_id" int4 NOT NULL,
  "user_id" int4 NOT NULL,
  "created_at" timestamp,
  "updated_at" timestamp,
  "deleted_at" timestamp NULL DEFAULT NULL ,
  PRIMARY KEY ("id")
);

DROP TABLE IF EXISTS "suppliers";
CREATE TABLE "suppliers" (
  "id" int4 NOT NULL GENERATED BY DEFAULT AS IDENTITY,
  "user_id" int4 NOT NULL,
  "type" varchar(3) NOT NULL,
  "id_card" varchar(30) NOT NULL,
  "id_card_front" varchar(255),
  "id_card_back" varchar(255),
  "legal_watchman" varchar(20),
  "enterprise_name" varchar(100),
  "enterprise_license" varchar(50),
  "area" varchar(20),
  "address" varchar(255),
  "created_at" timestamp,
  "updated_at" timestamp,
  "deleted_at" timestamp NULL DEFAULT NULL ,
PRIMARY KEY ("id")
);

DROP TABLE IF EXISTS "land";
CREATE TABLE "land" (
  "id" int4 NOT NULL GENERATED BY DEFAULT AS IDENTITY,
  "land_code" varchar(50) NOT NULL,
  "land_name" varchar(50) NOT NULL,
  "land_area" float NOT NULL,
  "user_id" int4 NOT NULL,
  "user_name" varchar(30) NOT NULL,
  "enterprise_name" varchar(100),
  "created_at" timestamp,
  "updated_at" timestamp,
  "deleted_at" timestamp NULL DEFAULT NULL ,
PRIMARY KEY ("id")
);

DROP TABLE IF EXISTS "land_basic_info";
CREATE TABLE "land_basic_info" (
  "id" int4 NOT NULL GENERATED BY DEFAULT AS IDENTITY,
  "land_code" varchar(50) NOT NULL,
  "land_name" varchar(50) NOT NULL,
  "geom" geometry(point, 4326) NOT NULL,
  "plant" varchar(50),
  "variety" varchar(50),
  "land_grade" varchar(30),
  "land_type" varchar(30),
  "land_area" float,
  "created_at" timestamp,
  "updated_at" timestamp,
  "deleted_at" timestamp NULL DEFAULT NULL ,
PRIMARY KEY ("id")
);

DROP TABLE IF EXISTS "land_plot_info";
CREATE TABLE "land_plot_info" (
"id" int4 NOT NULL GENERATED BY DEFAULT AS IDENTITY,


"created_at" timestamp,
"updated_at" timestamp,
"deleted_at" timestamp NULL DEFAULT NULL ,
PRIMARY KEY ("id")
);

DROP TABLE IF EXISTS "agriculture_layer";
CREATE TABLE "agriculture_layer" (
"id" int4 NOT NULL GENERATED BY DEFAULT AS IDENTITY,


"created_at" timestamp,
"updated_at" timestamp,
"deleted_at" timestamp NULL DEFAULT NULL ,
PRIMARY KEY ("id")
);
