package data

import (
	"fmt"
	"time"

	"com.dliangx.xplot/appserver/model"
)

type Msdata struct {
	ID                   int     `json:"id"`
	MemberLandId         int     `json:"member_land_id"`
	BlockCrop            string  `json:"block_crop"`
	BlockCropVariety     string  `json:"block_crop_variety"`
	IrrigationType       string  `json:"irrigation_type"`
	BlockArea            float64 `json:"block_area"`
	BlockCoordinates     string  `json:"block_coordinates"`
	EnclosureCoordinates string  `json:"enclosure_coordinates"`
	PreviewImageUrl      string  `json:"preview_image_url"`
	BlockId              int     `json:"block_id"`
	CreateTime           string  `json:"create_time"`
	UpdateTime           string  `json:"update_time"`
}

func (data Msdata) TransToOptArea() (area model.OptArea) {
	area.Properties["id"] = data.ID
	area.Properties["member_land_id"] = data.MemberLandId
	area.Properties["block_crop"] = data.BlockCrop
	area.Properties["block_crop_variety"] = data.BlockCropVariety
	area.Properties["irrigation_type"] = data.IrrigationType
	area.Properties["block_area"] = data.BlockArea
	area.Properties["block_coordinates"] = data.BlockCoordinates
	area.Properties["preview_image_url"] = data.PreviewImageUrl
	area.Properties["block_id"] = data.BlockId
	area.Properties["create_time"] = data.CreateTime
	area.Type = "polygon"
	ptime, err := time.Parse("2006-01-02 15:04:05", data.UpdateTime)
	if err != nil {
		fmt.Println("时间格式错误..")
	}
	area.OptTime = ptime

	// data.EnclosureCoordinates
	fmt.Printf("area: %v\n", area)
	return area
}
