# PostgreSQL 数据库编译安装指南 (Linux)

## 安装依赖
在开始编译之前，需要安装一些依赖包：
```sh
sudo apt-get update
sudo apt-get install build-essential wget
```

## 下载并安装依赖包源码
下载并安装libreadline、zlib、flex和bison的源码：
```sh
# 安装libreadline
wget https://ftp.gnu.org/gnu/readline/readline-8.1.tar.gz
tar -xzf readline-8.1.tar.gz
cd readline-8.1
./configure
make
sudo make install
cd ..

# 安装zlib
wget https://zlib.net/zlib-1.2.11.tar.gz
tar -xzf zlib-1.2.11.tar.gz
cd zlib-1.2.11
./configure
make
sudo make install
cd ..

# 安装flex
wget https://github.com/westes/flex/releases/download/v2.6.4/flex-2.6.4.tar.gz
tar -xzf flex-2.6.4.tar.gz
cd flex-2.6.4
./configure
make
sudo make install
cd ..

# 安装bison
wget https://ftp.gnu.org/gnu/bison/bison-3.7.6.tar.gz
tar -xzf bison-3.7.6.tar.gz
cd bison-3.7.6
./configure
make
sudo make install
cd ..
```

## 下载PostgreSQL源码
从PostgreSQL官方网站下载最新版本的源码：
```sh
wget https://ftp.postgresql.org/pub/source/v16.0/postgresql-16.0.tar.gz
tar -xzf postgresql-16.0.tar.gz
cd postgresql-16.0
```

## 编译和安装PostgreSQL
配置、编译并安装PostgreSQL：
```sh
./configure
make
sudo make install
```

## 编译安装PostgreSQL依赖包
编译并安装PostgreSQL依赖包：
```sh
cd contrib
make
sudo make install
```

## 安装PostGIS 3.5
下载并安装PostGIS 3.5及其依赖包：
```sh
# 安装GEOS
wget http://download.osgeo.org/geos/geos-3.10.2.tar.bz2
tar -xjf geos-3.10.2.tar.bz2
cd geos-3.10.2
./configure
make
sudo make install
cd ..

# 安装Proj
wget http://download.osgeo.org/proj/proj-8.2.0.tar.gz
tar -xzf proj-8.2.0.tar.gz
cd proj-8.2.0
./configure
make
sudo make install
cd ..

# 安装GDAL
wget http://download.osgeo.org/gdal/3.4.1/gdal-3.4.1.tar.gz
tar -xzf gdal-3.4.1.tar.gz
cd gdal-3.4.1
./configure
make
sudo make install
cd ..

# 安装PostGIS
wget https://download.osgeo.org/postgis/source/postgis-3.5.0.tar.gz
tar -xzf postgis-3.5.0.tar.gz
cd postgis-3.5.0
./configure
make
sudo make install
```

## 创建用户和初始化数据库
创建PostgreSQL用户并初始化数据库：
```sh
sudo useradd postgres
sudo mkdir /usr/local/pgsql/data
sudo chown postgres /usr/local/pgsql/data
sudo -i -u postgres
initdb -D /usr/local/pgsql/data
```

## 启动数据库
启动PostgreSQL数据库服务器：
```sh
pg_ctl -D /usr/local/pgsql/data -l logfile start
```

## 创建数据库
创建一个新的数据库：
```sh
createdb mydb
```

## 安装PostGIS扩展
在数据库中安装PostGIS扩展：
```sh
psql -d mydb -c "CREATE EXTENSION postgis;"
psql -d mydb -c "CREATE EXTENSION postgis_topology;"
```

## 连接数据库
使用psql连接到新创建的数据库：
```sh
psql mydb
```

# API 文档

## 几何API

### 保存几何数据
- **URL:** `/geometry`
- **方法:** `PUT`
- **处理函数:** `handler.SaveGeometry`
- **描述:** 保存几何数据。
- **请求参数:**
  - `geometry`: 几何数据对象 (JSON)
    - `id`: 几何数据的唯一标识符 (int)
    - `type`: 几何数据类型 (string)
    - `properties`: 几何数据属性 (map[string]interface{})
    - `geometry`: 几何数据 (GeoJSON)

### 获取几何数据
- **URL:** `/geometry`
- **方法:** `GET`
- **处理函数:** `handler.GetGeometry`
- **描述:** 获取几何数据。
- **请求参数:** 无

### 更新几何数据
- **URL:** `/geometry`
- **方法:** `POST`
- **处理函数:** `handler.UpdateGeometry`
- **描述:** 更新几何数据。
- **请求参数:**
  - `geometry`: 更新后的几何数据对象 (JSON)
    - `id`: 几何数据的唯一标识符 (int)
    - `type`: 几何数据类型 (string)
    - `properties`: 几何数据属性 (map[string]interface{})
    - `geometry`: 几何数据 (GeoJSON)

### 删除几何数据
- **URL:** `/geometry`
- **方法:** `DELETE`
- **处理函数:** `handler.DeleteGeometry`
- **描述:** 删除几何数据。
- **请求参数:**
  - `id`: 几何数据的唯一标识符 (string)

### 查找相关几何数据
- **URL:** `/geometry/related`
- **方法:** `POST`
- **处理函数:** `handler.FindRelatedGeometry`
- **描述:** 查找相关几何数据。
- **请求参数:**
  - `geometry`: 几何数据对象 (JSON)
    - `id`: 几何数据的唯一标识符 (int)
    - `type`: 几何数据类型 (string)
    - `properties`: 几何数据属性 (map[string]interface{})
    - `geometry`: 几何数据 (GeoJSON)

### 检查两个可选区域是否交叉
- **URL:** `/geometry/check`
- **方法:** `POST`
- **处理函数:** `handler.CheckTwoOptAreaIsCross`
- **描述:** 检查两个可选区域是否交叉。
- **请求参数:**
  - `area1`: 第一个区域对象 (JSON)
    - `id`: 区域ID (int)
    - `type`: 区域类型 (string)
    - `properties`: 区域属性 (map[string]interface{})
    - `geometry`: 区域边界坐标点 (GeoJSON)
  - `area2`: 第二个区域对象 (JSON)
    - `id`: 区域ID (int)
    - `type`: 区域类型 (string)
    - `properties`: 区域属性 (map[string]interface{})
    - `geometry`: 区域边界坐标点 (GeoJSON)

### 计算区域中心
- **URL:** `/geometry/calc_center`
- **方法:** `POST`
- **处理函数:** `handler.CalcAreasCenter`
- **描述:** 计算区域中心。
- **请求参数:**
  - `areas`: 区域对象数组 (JSON)
    - `id`: 区域ID (int)
    - `type`: 区域类型 (string)
    - `properties`: 区域属性 (map[string]interface{})
    - `geometry`: 区域边界坐标点 (GeoJSON)

### 获取重合度90以上交叉区域
- **URL:** `/geometry/get90_cross_area`
- **方法:** `POST`
- **处理函数:** `handler.Get90CrossArea`
- **描述:** 获取重合度90以上交叉区域。
- **请求参数:**
  - `area`: 区域对象 (JSON)
    - `id`: 区域ID (int)
    - `type`: 区域类型 (string)
    - `properties`: 区域属性 (map[string]interface{})
    - `geometry`: 区域边界坐标点 (GeoJSON)