package route

import (
	"com.dliangx.xplot/appserver/handler"
	"github.com/cloudwego/hertz/pkg/app/server"
)

func Register(r *server.Hertz) {
	r.PUT("/geometry", handler.SaveGeometry)
	r.GET("/geometry", handler.GetGeometry)
	r.POST("/geometry", handler.UpdateGeometry)
	r.DELETE("/geometry", handler.DeleteGeometry)
	r.POST("/geometry/related", handler.FindRelatedGeometry)
	r.POST("/geometry/check", handler.CheckTwoOptAreaIsCross)
	r.POST("/geometry/calc_center", handler.CalcAreasCenter)
}
