package handler

import (
	"context"
	"fmt"

	"com.dliangx.xplot/appserver/model"
	"github.com/cloudwego/hertz/pkg/app"
	"github.com/twpayne/go-geom"
	"github.com/twpayne/go-geom/encoding/geojson"
	"github.com/twpayne/go-geom/encoding/wkt"
)

func SaveGeometry(ctx context.Context, c *app.RequestContext) {
	var resp model.GeoJson
	c.BindAndValidate(&resp)
	switch resp.Opt {
	case 1:
		break
	case 2:
		break
	case 3:
		break
	default:
		break
	}

}

func UpdateGeometry(ctx context.Context, c *app.RequestContext) {
	var resp model.GeoJson
	c.BindAndValidate(&resp)
	switch resp.Opt {
	case 1:
		break
	case 2:
		break
	case 3:
		break
	default:
		break
	}

}

func GetGeometry(ctx context.Context, c *app.RequestContext) {
	var id string
	c.BindAndValidate(&id)
}

func DeleteGeometry(ctx context.Context, c *app.RequestContext) {
	var id string
	c.BindAndValidate(&id)
}

func FindRelatedGeometry(ctx context.Context, c *app.RequestContext) {
	var resp model.GeoJson
	c.BindAndValidate(&resp)
	switch resp.Opt {
	case 1:
		break
	case 2:
		break
	case 3:
		break
	default:
		break
	}

}

func CheckTwoOptAreaIsCross(ctx context.Context, c *app.RequestContext) {
	var resp []model.GeoJson
	c.BindAndValidate(&resp)

}

func TransGeoToWKT(geojsonStr string) (string, error) {
	// 解码GeoJSON字符串为geom.T类型
	var g geom.T
	if err := geojson.Unmarshal([]byte(geojsonStr), &g); err != nil {
		return "", fmt.Errorf("error unmarshalling GeoJSON: %w", err)
	}

	// 将geom.T类型转换为WKT
	wktStr, err := wkt.Marshal(g)
	if err != nil {
		return "", fmt.Errorf("error marshalling to WKT: %w", err)
	}

	return string(wktStr), nil
}
