package main

import (
	"context"

	"github.com/cloudwego/hertz/pkg/app"
	"github.com/cloudwego/hertz/pkg/app/server"
	"github.com/cloudwego/hertz/pkg/common/utils"
	"github.com/cloudwego/hertz/pkg/protocol/consts"
	"github.com/hertz-contrib/cors"

	"com.dliangx.xplot/appserver/db"
	"com.dliangx.xplot/appserver/geo"
	"com.dliangx.xplot/appserver/route"
)

func main() {
	h := server.Default(
		server.WithHostPorts(":8686"),
	)
	defer db.DB.Close()

	// CORS middleware configuration
	h.Use(cors.New(cors.Config{
		AllowOrigins:     []string{"*"},
		AllowMethods:     []string{"GET", "POST", "PUT", "DELETE", "OPTIONS"},
		AllowHeaders:     []string{"Origin", "Content-Type", "Accept", "Authorization"},
		ExposeHeaders:    []string{"Content-Length"},
		AllowCredentials: true,
		MaxAge:           12 * 3600,
	}))

	h.GET("/ping", func(ctx context.Context, c *app.RequestContext) {
		c.JSON(consts.StatusOK, utils.H{"message": "pong"})
	})

	h.POST("/geojson/process", geo.HandleProcessGeoJSON)
	route.Register(h)

	h.Spin()
}
