package handler

import (
	"encoding/json"
	"fmt"
	"testing"

	"nlt.com/pf/model"
	"nlt.com/pf/nltconst"
)

func TestAuthEncrypt(t *testing.T) {
	var resp model.HttpBodyResp[model.AuthResp]
	resp.Head.Code = "11111"
	resp.Head.ServiceSn = "1234567"
	resp.Head.ServiceTime = nltconst.GetNowTime()
	resp.Response.DirectURL = "https://baidu.com"
	resp.Response.PayOrderNo = "2239999999"
	cresp, err := model.EncryptAndSign(resp)
	if err != nil {
		fmt.Println(err)
	}
	jsonResp, _ := json.Marshal(cresp)
	fmt.Println(string(jsonResp))

}

func TestEncrypt(t *testing.T) {
	var req model.HttpBody[model.ReqHead, model.AuthReq]
	req.Head.BusinessChannel = "spdbmbank"
	req.Head.RequestTime = "20550623072501"
	req.Head.VersionId = "V1.0"
	req.Head.ChannelId = "APP-01"
	req.Head.ServiceSn = "00175506230725010158298153"
	req.Head.Sid = "00175506230725010158298153"
	req.Head.ServiceId = "pfyhcxzfjg"

	req.Body.Addr = ""
	req.Body.UserName = "龙一"
	req.Body.IdNo = "420982198604026032"
	req.Body.DuebillNoOrg = "1234567890"
	req.Body.LoanAmt = "2000000"
	req.Body.Term = "12"
	req.Body.CellPhone = "1311111111"
	req.Body.Addr = "234567890"
	req.Body.JumURL = "www.baidu.com"

	model.Ecas[model.ReqHead, model.AuthReq](req)
}
