package handler

import (
	"fmt"
	"testing"

	"nlt.com/pf/model"
	"nlt.com/pf/nltconst"
)

func TestAuthEncrypt(t *testing.T) {
	var resp model.HttpBodyResp[model.AuthResp]
	resp.Head.Code = "11111"
	resp.Head.ServiceSn = "23555555"
	resp.Head.ServiceTime = nltconst.GetNowTime()
	resp.Response.DirectURL = "https://baidu.com"
	resp.Response.PayOrderNo = "2239999999"
	cresp, err := model.EncryptAndSign(resp)
	fmt.Println(cresp)
	fmt.Println(err)
}

func TestAuthDecrypt(t *testing.T) {
	var resp model.HttpBodyResp[model.PayResultReq]
	resp.Head.Code = "11111"
	resp.Head.ServiceSn = "23555555"
	resp.Head.ServiceTime = nltconst.GetNowTime()
	resp.Response.DuebillNoOrg = "99999999999"
	cresp, err := model.EncryptAndSign(resp)
	if err != nil {
		fmt.Println(err)
	}
	var res model.CryptHttpBodyReq[[]byte]
	res.Request.Head.ServiceSn = cresp.Response.Head.ServiceSn
	res.Request.Request = cresp.Response.Response
	res.Signature = cresp.Signature
	fmt.Println(res)
	model.VerifyAndDecrypt[model.AuthResp](res)
}
