package nltconst

import "time"

type NLTStatus string

const (
	SUCCESS              NLTStatus = "000000"
	NODATA                         = "W020103"
	PARAM_EMPTY                    = "W140001"
	PARAM_ERROR                    = "W140003"
	BODY_ERROR                     = "W140031"
	SYS_ERROR                      = "W149999"
	NO_AUTHOR                      = "W380001"
	PERSON_INFO_NO_MATCH           = "W380002"
	NO_ACCESS_BUSI                 = "W380003"
	DATA_LOADING                   = "W380004"
	VERIFY_ERROR                   = "W380005"
	DECRYPT_ERROR                  = "W380006"
)

func (c NLTStatus) String() string {
	switch c {
	case SUCCESS:
		return "成功"
	case NODATA:
		return "查询无数据"
	case PARAM_EMPTY:
		return "请求参数为空"
	case PARAM_ERROR:
		return "请求参数各式不正确"
	case BODY_ERROR:
		return "报文体格式不正确"
	case SYS_ERROR:
		return "系统异常"
	case NO_AUTHOR:
		return "未授权"
	case PERSON_INFO_NO_MATCH:
		return "申请人信息比对不一致"
	case NO_ACCESS_BUSI:
		return "非准入行业"
	case DATA_LOADING:
		return "数据获取中"
	default:
		return "成功"
	}
}

const DURL = "https://tknltdev.agrolinking.cn/tk/index.html"

func GetNowTime() string {
	currentTime := time.Now()

	// 定义时间格式
	const layout = "20060102150405"

	// 格式化时间
	formattedTime := currentTime.Format(layout)
	return formattedTime
}
