package handler

import (
	"context"
	"log"

	"github.com/cloudwego/hertz/pkg/app"
	"github.com/cloudwego/hertz/pkg/protocol/consts"
	_ "github.com/go-sql-driver/mysql"
	"nlt.com/pf/db"
	"nlt.com/pf/model"
	"nlt.com/pf/nltconst"
)

func QueryPayResult(ctx context.Context, c *app.RequestContext) {
	var err error
	var creq model.CryptHttpBodyReq[string]
	var req model.HttpBodyReq[model.PayResultReq]
	var resp model.HttpBodyResp[model.PayResultResp]
	err = c.BindAndValidate(&creq)
	req = model.VerifyAndDecrypt[model.PayResultReq](creq)
	if err != nil {
		resp.Head.Code = nltconst.PARAM_ERROR
		resp.Head.ServiceTime = nltconst.GetNowTime()
		c.JSON(consts.StatusOK, model.EncryptAndSign(resp))
		return
	}

	println(req.Request.DuebillNoOrg)

	rows, err := db.DB.Query("select serial_no,status,createtime,reject_cause from loan_orderinfo where serial_no = ? order by createtime", &req.Request.DuebillNoOrg)

	if err != nil {

		log.Println(err)
		resp.Head.Code = nltconst.SYS_ERROR
		resp.Head.ServiceTime = nltconst.GetNowTime()
		resp.Head.ServiceSn = req.Head.ServiceSn
		c.JSON(consts.StatusOK, model.EncryptAndSign(resp))
		return
	}
	var count int
	for rows.Next() {
		count++
		err := rows.Scan(&count, &resp.Response.DuebillNoOrg, &resp.Response.Status, &resp.Response.OrderTime, &resp.Response.FailMsg)
		if err != nil {
			log.Println(err)
		}
	}

	if count == 0 {
		log.Println(err)
		resp.Head.Code = nltconst.NODATA
		resp.Head.ServiceTime = nltconst.GetNowTime()
		resp.Head.ServiceSn = req.Head.ServiceSn
		c.JSON(consts.StatusOK, model.EncryptAndSign(resp))
		return
	}

	// 检查遍历过程中是否有错误发生
	if err = rows.Err(); err != nil {
		log.Println(err)
		resp.Head.Code = nltconst.SYS_ERROR
		resp.Head.ServiceTime = nltconst.GetNowTime()
		resp.Head.ServiceSn = req.Head.ServiceSn
		c.JSON(consts.StatusOK, model.EncryptAndSign(resp))
		return
	}
	resp.Head.Code = string(nltconst.SUCCESS)
	resp.Head.ServiceTime = nltconst.GetNowTime()
	resp.Head.ServiceSn = req.Head.ServiceSn

	c.JSON(consts.StatusOK, model.EncryptAndSign(resp))
	return

}
