package handler

import (
	"context"
	"log"

	"github.com/cloudwego/hertz/pkg/app"
	"github.com/cloudwego/hertz/pkg/protocol/consts"
	_ "github.com/go-sql-driver/mysql"
	"nlt.com/pf/db"
	"nlt.com/pf/model"
	"nlt.com/pf/nltconst"
)

func QueryPayResult(ctx context.Context, c *app.RequestContext) {
	var err error
	var creq model.CryptHttpBodyReq
	var req model.HttpBodyReq[model.PayResultReq]
	var resp model.HttpBodyResp[model.PayResultResp]
	var cresp model.CryptHttpBodyResp
	err = c.BindAndValidate(&creq)
	if err != nil {
		resp.Head.Code = nltconst.PARAM_ERROR
		resp.Head.ServiceTime = nltconst.GetNowTime()
		resp.Head.ServiceSn = creq.Request.Head.ServiceSn
		cresp.Response.Head = resp.Head
		c.JSON(consts.StatusOK, cresp)
		return
	}
	req, err = model.VerifyAndDecrypt[model.PayResultReq](creq)
	if err != nil {
		if err.Error() == "解密错误" {
			resp.Head.Code = nltconst.DECRYPT_ERROR
		} else if err.Error() == "验签错误" {
			resp.Head.Code = nltconst.VERIFY_ERROR
		} else {
			resp.Head.Code = nltconst.SYS_ERROR
		}
		resp.Head.ServiceTime = nltconst.GetNowTime()
		resp.Head.ServiceSn = creq.Request.Head.ServiceSn
		cresp.Response.Head = resp.Head
		c.JSON(consts.StatusOK, cresp)
		return
	}

	println(req.Request.DuebillNoOrg)

	rows, err := db.DB.Query("select serial_no,status,createtime,reject_cause from loan_orderinfo where serial_no = ? and status = 37 and amount_r <= quota_r order by createtime",
		&req.Request.DuebillNoOrg)

	if err != nil {

		log.Println(err)
		resp.Head.Code = nltconst.SYS_ERROR
		resp.Head.ServiceTime = nltconst.GetNowTime()
		resp.Head.ServiceSn = req.Head.ServiceSn
		cresp.Response.Head = resp.Head
		c.JSON(consts.StatusOK, cresp)
		return
	}
	var count int
	for rows.Next() {
		count++
		err := rows.Scan(&resp.Response.DuebillNoOrg, &resp.Response.Status, &resp.Response.OrderTime, &resp.Response.FailMsg)
		if err != nil {
			log.Println(err)
		}
	}

	if count == 0 {
		log.Println(err)
		resp.Head.Code = nltconst.NODATA
		resp.Head.ServiceTime = nltconst.GetNowTime()
		resp.Head.ServiceSn = req.Head.ServiceSn
		cresp.Response.Head = resp.Head
		c.JSON(consts.StatusOK, cresp)
		return
	}

	// 检查遍历过程中是否有错误发生
	if err = rows.Err(); err != nil {
		log.Println(err)
		resp.Head.Code = nltconst.SYS_ERROR
		resp.Head.ServiceTime = nltconst.GetNowTime()
		resp.Head.ServiceSn = req.Head.ServiceSn
		cresp.Response.Head = resp.Head
		c.JSON(consts.StatusOK, cresp)
		return
	}
	resp.Head.Code = string(nltconst.SUCCESS)
	resp.Head.ServiceTime = nltconst.GetNowTime()
	resp.Head.ServiceSn = req.Head.ServiceSn
	cresp, _ = model.EncryptAndSign(resp)
	c.JSON(consts.StatusOK, cresp)

}
