package main

import (
	"context"

	"github.com/cloudwego/hertz/pkg/app"
	"github.com/cloudwego/hertz/pkg/app/server"
	"nlt.com/pf/route"
)

func main() {
	h := server.Default()
	route.Register(h)
	h.LoadHTMLGlob("html/*")

	h.Static("/", "./html")

	h.GET("/", func(c context.Context, ctx *app.RequestContext) {
		ctx.HTML(200, "index.html", nil)
	})
	h.Spin()
}
