package handler

import (
	"context"
	"fmt"
	"log"

	"github.com/cloudwego/hertz/pkg/app"
	"github.com/cloudwego/hertz/pkg/protocol/consts"
	"nlt.com/pf/db"
	"nlt.com/pf/model"
	"nlt.com/pf/nltconst"
)

func Auth(ctx context.Context, c *app.RequestContext) {
	var err error
	var creq model.CryptHttpBodyReq
	var req model.HttpBodyReq[model.AuthReq]
	var resp model.HttpBodyResp[model.AuthResp]
	var cresp model.CryptHttpBodyResp
	err = c.BindAndValidate(&creq)
	if err != nil {
		resp.Head.Code = nltconst.PARAM_ERROR
		resp.Head.ServiceTime = nltconst.GetNowTime()
		resp.Head.ServiceSn = req.Head.ServiceSn
		cresp.Response.Head = resp.Head
		c.JSON(consts.StatusOK, cresp)
		return
	}
	req, err = model.VerifyAndDecrypt[model.AuthReq](creq)
	fmt.Println(req)
	if err != nil {
		if err.Error() == "解密错误" {
			resp.Head.Code = nltconst.DECRYPT_ERROR
		} else if err.Error() == "验签错误" {
			resp.Head.Code = nltconst.VERIFY_ERROR
		} else {
			resp.Head.Code = nltconst.SYS_ERROR
		}
		resp.Head.ServiceTime = nltconst.GetNowTime()
		resp.Head.ServiceSn = req.Head.ServiceSn
		cresp.Response.Head = resp.Head
		c.JSON(consts.StatusOK, cresp)
		return
	}
	rows, err := db.DB.Query("select order_sn, farmer from loan_orderinfo where id_num = ? order by createtime desc limit 1", &req.Request.IdNo)
	if err != nil {
		log.Println(err)
		resp.Head.Code = nltconst.SYS_ERROR
		resp.Head.ServiceTime = nltconst.GetNowTime()
		resp.Head.ServiceSn = req.Head.ServiceSn
		cresp.Response.Head = resp.Head
		c.JSON(consts.StatusOK, cresp)
		return
	}
	var ordersn string
	var name string

	for rows.Next() {
		err := rows.Scan(&ordersn, &name)
		if err != nil {
			log.Println(err)
		}
	}
	if req.Request.UserName != name {
		resp.Head.Code = string(nltconst.PERSON_INFO_NO_MATCH)
		resp.Head.ServiceTime = nltconst.GetNowTime()
		resp.Head.ServiceSn = req.Head.ServiceSn
		cresp.Response.Head = resp.Head
		c.JSON(consts.StatusOK, cresp)
		return
	}

	_, err = db.DB.Exec("update loan_orderinfo set serial_no = ?,disburse_sign_url=?,amount_r=?,term_r=? where order_sn=? ",
		&req.Request.DuebillNoOrg, &req.Request.JumURL, &req.Request.LoanAmt, &req.Request.Term, &ordersn)
	if err != nil {
		log.Println(err)
		resp.Head.Code = nltconst.SYS_ERROR
		resp.Head.ServiceTime = nltconst.GetNowTime()
		resp.Head.ServiceSn = req.Head.ServiceSn
		cresp.Response.Head = resp.Head
		c.JSON(consts.StatusOK, cresp)
		return
	}

	resp.Head.Code = string(nltconst.SUCCESS)
	resp.Head.ServiceTime = nltconst.GetNowTime()
	resp.Head.ServiceSn = req.Head.ServiceSn
	resp.Response.DirectURL = nltconst.DURL + "?param=" + req.Request.DuebillNoOrg
	cresp, _ = model.EncryptAndSign(resp)
	c.JSON(consts.StatusOK, cresp)

}
