package handler

import (
	"context"
	"log"

	"github.com/cloudwego/hertz/pkg/app"
	"github.com/cloudwego/hertz/pkg/protocol/consts"
	"nlt.com/pf/db"
	"nlt.com/pf/model"
	"nlt.com/pf/nltconst"
)

func QueryJumpUrl(ctx context.Context, c *app.RequestContext) {
	var err error
	var req model.PayResultReq
	var resp model.HttpBodyResp[string]
	err = c.BindAndValidate(&req)
	if err != nil {
		resp.Head.Code = nltconst.PARAM_ERROR
		resp.Head.ServiceTime = nltconst.GetNowTime()
		c.JSON(consts.StatusOK, resp)
		return
	}

	println(req.DuebillNoOrg)

	rows, err := db.DB.Query("select disburse_sign_url from loan_orderinfo where serial_no = ? ", &req.DuebillNoOrg)

	if err != nil {

		log.Println(err)
		resp.Head.Code = nltconst.SYS_ERROR
		resp.Head.ServiceTime = nltconst.GetNowTime()
		c.JSON(consts.StatusOK, resp)
		return
	}
	var count int
	var url string
	for rows.Next() {
		count++
		err := rows.Scan(&url)
		if err != nil {
			log.Println(err)
		}
	}
	if count == 0 {
		log.Println(err)
		resp.Head.Code = nltconst.NODATA
		resp.Head.ServiceTime = nltconst.GetNowTime()
		c.JSON(consts.StatusOK, resp)
		return
	}

	resp.Head.Code = string(nltconst.SUCCESS)
	resp.Head.ServiceTime = nltconst.GetNowTime()
	resp.Response = url
	c.JSON(consts.StatusOK, resp)
}
