package handler

import (
	"encoding/json"
	"fmt"
	"testing"

	"nlt.com/pf/model"
	"nlt.com/pf/nltconst"
)

func TestAuthEncrypt(t *testing.T) {
	var resp model.HttpBodyResp[model.AuthResp]
	resp.Head.Code = "11111"
	resp.Head.ServiceSn = "1234567"
	resp.Head.ServiceTime = nltconst.GetNowTime()
	resp.Response.DirectURL = "https://baidu.com"
	resp.Response.PayOrderNo = "2239999999"
	cresp, err := model.EncryptAndSign(resp)
	if err != nil {
		fmt.Println(err)
	}
	jsonResp, _ := json.Marshal(cresp)
	fmt.Println(string(jsonResp))

}
