# 浦发银行农链通接口系统

**nlt-pufa-interface** 是一个基于Go语言开发的农链通接口系统，为浦发银行提供安全可靠的贷款业务API服务。

## 📋 项目概览

- **项目名称**: nlt-pufa-interface（农链通-浦发银行接口）
- **技术栈**: Go + Hertz 框架 + MySQL + 国密SM2加密
- **运行端口**: 8970
- **业务场景**: 农业贷款申请、支付状态查询、业务流程跳转

## 🚀 主要功能

### 核心API接口

#### 1. 认证接口 `/nlt/pufa/auth`
- **功能**: 处理用户身份认证和贷款申请
- **方法**: POST
- **验证流程**: 
  - 通过身份证号查询农户信息
  - 验证姓名与身份证号匹配
  - 更新贷款订单信息（流水号、金额、期限、跳转URL）
- **返回**: 提供直接跳转URL

#### 2. 支付结果查询 `/nlt/pufa/queryPayResult`
- **功能**: 查询贷款订单的支付状态
- **方法**: POST
- **查询条件**: 状态为37且金额小于等于配额的订单
- **返回数据**: 订单状态（SUCCESS/FAIL）、创建时间、失败原因等

#### 3. 跳转URL查询 `/nlt/pufa/queryJumpUrl`
- **功能**: 获取订单对应的业务跳转链接
- **方法**: POST
- **用途**: 为前端页面提供后续操作的URL

## 🔐 安全机制

项目采用**国密SM2算法**实现端到端安全通信：

### 加密流程
- **请求加密**: 客户端使用SM2公钥加密请求数据
- **响应加密**: 服务端使用SM2公钥加密响应数据
- **数字签名**: 使用SM2私钥进行数字签名
- **签名验证**: 严格的签名验证和解密流程

### 错误代码
| 代码 | 说明 |
|------|------|
| 000000 | 成功 |
| W020103 | 查询无数据 |
| W140001 | 请求参数为空 |
| W140003 | 请求参数格式不正确 |
| W149999 | 系统异常 |
| W380002 | 申请人信息比对不一致 |
| W380005 | 验签错误 |
| W380006 | 解密错误 |

## 🗄️ 数据库设计

### 主要数据表: `loan_orderinfo`
存储农户贷款订单信息，包含以下关键字段：
- `id_num`: 身份证号
- `farmer`: 农户姓名
- `order_sn`: 订单编号
- `serial_no`: 流水号
- `amount_r`: 贷款金额
- `term_r`: 贷款期限
- `status`: 订单状态
- `disburse_sign_url`: 业务跳转URL
- `createtime`: 创建时间

## 🏗️ 项目结构

```
nlt-pufa-interface/
├── main.go              # 应用程序入口
├── go.mod              # Go模块依赖
├── db/                 # 数据库相关
│   └── init.go         # 数据库初始化
├── handler/            # HTTP处理器
│   ├── auth.go         # 认证接口
│   ├── pay_result.go   # 支付结果查询
│   └── jump_url.go     # URL跳转查询
├── model/              # 数据模型
│   ├── auth.go         # 认证相关模型
│   ├── http_body.go    # HTTP请求响应模型
│   └── pay_result.go   # 支付结果模型
├── route/              # 路由配置
│   └── register.go     # 路由注册
├── nltconst/           # 常量定义
│   ├── const.go        # 业务常量
│   └── crypt.go        # 加密相关
└── html/               # 前端页面
    ├── index.html      # 担保费缴纳页面
    └── logo.jpg        # 品牌标识
```

## 🌐 前端界面

提供担保费缴纳提醒页面：
- **功能**: 线下担保费缴纳流程引导
- **交互**: 点击确定按钮自动跳转到相应业务URL
- **响应式**: 自适应手机和桌面设备
- **用户体验**: 简洁美观的界面设计

## 🛠️ 安装与使用

### 环境要求
- Go 1.21.13+
- MySQL 5.7+
- Linux/macOS/Windows

### 安装步骤

1. **克隆项目**
```bash
git clone <repository-url>
cd nlt-pufa-interface
```

2. **安装依赖**
```bash
go mod download
```

3. **配置数据库**
修改 `db/init.go` 中的数据库连接信息：
```go
var dsn = "username:password@tcp(host:port)/database?charset=utf8&parseTime=True&loc=Local"
```

4. **启动服务**
```bash
go run main.go
```

服务将在 `http://localhost:8970` 启动

### API调用示例

#### 认证接口调用
```bash
curl -X POST http://localhost:8970/nlt/pufa/auth \
  -H "Content-Type: application/json" \
  -d '{
    "request": {
      "head": {
        "requestTime": "20231201120000",
        "versionId": "1.0",
        "serviceId": "auth",
        "serviceSn": "12345",
        "channelId": "web",
        "sid": "session123",
        "businessChannel": "online"
      },
      "body": "加密后的请求数据"
    },
    "signature": "数字签名"
  }'
```

## 📊 业务流程

```mermaid
%%{init: {'theme':'base', 'themeVariables': {'background': '#ffffff', 'primaryColor': '#fff', 'primaryTextColor': '#000', 'primaryBorderColor': '#000', 'lineColor': '#000'}}}%%
sequenceDiagram
    participant Client as 客户端
    participant API as 接口服务
    participant DB as 数据库
    participant Bank as 银行系统

    Client->>API: 1. 身份认证请求(加密)
    API->>API: 解密&验签
    API->>DB: 查询农户信息
    DB-->>API: 返回农户数据
    API->>API: 验证身份信息
    API->>DB: 更新订单信息
    API->>API: 加密&签名
    API-->>Client: 返回认证结果

    Client->>API: 2. 查询支付结果
    API->>DB: 查询订单状态
    DB-->>API: 返回状态信息
    API-->>Client: 返回支付状态

    Client->>API: 3. 获取跳转URL
    API->>DB: 查询跳转链接
    DB-->>API: 返回URL
    API-->>Client: 返回跳转地址
```

## 🔧 开发说明

### 核心依赖
- **Hertz**: 高性能HTTP框架
- **gmsm**: 国密算法实现
- **mysql**: MySQL数据库驱动

### 代码规范
- 遵循Go官方编码规范
- 使用驼峰命名法
- 添加必要的错误处理
- 保持代码简洁可读

### 日志记录
系统包含详细的操作日志，便于：
- 问题排查和调试
- 业务流程跟踪
- 安全审计

## 🚦 部署建议

### 生产环境配置
1. **数据库安全**: 使用独立的数据库用户，限制权限
2. **HTTPS**: 配置SSL证书，启用HTTPS
3. **防火墙**: 限制端口访问，只允许必要的IP
4. **监控**: 配置应用监控和日志收集
5. **备份**: 定期备份数据库和配置文件

### 性能优化
- 数据库连接池优化
- 适当的缓存策略
- 接口限流保护
- 负载均衡配置

## 📝 许可证

本项目仅供农业贷款业务使用，涉及金融数据安全，请严格按照相关法规使用。

## 📚 详细文档

更多详细文档请查看 [`docs/`](./docs/) 目录：

- [📖 文档目录](./docs/README.md) - 完整的文档索引和使用指南
- [🚀 项目部署运行指南](./docs/DEPLOYMENT_GUIDE.md) - 环境配置、启动流程和运维指南
- [🏢 业务设计文档](./docs/BUSINESS_DESIGN.md) - 担保费支付逻辑和风控机制详解
- [🔌 API接口集成文档](./docs/API_INTEGRATION.md) - 外部系统集成指南

## 🤝 贡献

如需贡献代码或报告问题，请联系项目维护团队。

---

**注意**: 本系统处理敏感的金融数据，部署和使用时请严格遵守相关安全规范和法律法规。 