# 📚 项目文档目录

本目录包含浦发银行农链通接口系统的所有详细文档。

## 📋 文档列表

### 🏢 业务设计文档
**文件**: [`BUSINESS_DESIGN.md`](./BUSINESS_DESIGN.md)

**内容概述**:
- 担保费支付业务逻辑详解
- 预授信额度控制机制
- 风险控制策略
- 系统架构角色分工
- 业务流程图和数据流转

**适用人群**: 产品经理、业务分析师、系统架构师

---

### 🔌 API接口集成文档  
**文件**: [`API_INTEGRATION.md`](./API_INTEGRATION.md)

**内容概述**:
- 外部系统调用本系统的完整指南
- 3个对外接口的详细规范
- 国密SM2加密集成要求
- 技术实现示例和测试指南
- 错误码说明和故障排查

**适用人群**: 外部开发团队、系统集成工程师、测试工程师

---

### 🚀 项目部署运行指南
**文件**: [`DEPLOYMENT_GUIDE.md`](./DEPLOYMENT_GUIDE.md)

**内容概述**:
- 完整的环境配置和依赖安装指南
- 开发和生产环境的启动流程
- 详细的架构说明和组件介绍
- 监控、调试和故障排查方法
- Docker、Systemd等生产部署方案

**适用人群**: 运维工程师、开发工程师、系统管理员

---

## 🔗 相关文档

### 项目概述
- [项目README](../README.md) - 项目总体介绍和快速开始指南

### 技术文档
- [Go模块依赖](../go.mod) - 项目依赖管理
- [数据库配置](../db/init.go) - 数据库连接配置
- [路由配置](../route/register.go) - API路由注册

## 📖 文档使用说明

### 📋 阅读顺序建议

1. **新手入门**: 
   - 先阅读 [项目README](../README.md) 了解项目概况
   - 再阅读 `BUSINESS_DESIGN.md` 理解业务逻辑

2. **系统集成**: 
   - 重点阅读 `API_INTEGRATION.md` 
   - 参考技术实现示例进行开发

3. **深入理解**: 
   - 结合源代码阅读业务设计文档
   - 理解系统架构和设计思路

### 🔄 文档更新

- **更新频率**: 跟随系统版本更新
- **维护责任**: 开发团队负责技术文档，产品团队负责业务文档
- **审核流程**: 重要变更需经过技术和业务双重审核

### 📞 文档反馈

如发现文档问题或需要补充说明，请：
1. 提交Issue到项目仓库
2. 联系相关文档维护人员
3. 提出Pull Request进行修改

---

**文档版本**: v1.0  
**最后更新**: 2024年  
**维护团队**: 浦发银行农链通系统开发组 